<?php

namespace App\Http\Controllers\Doctor;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class PatientManagementController extends Controller
{
    public function index()
    {
        return view('doctor.patient.patient-management');
    }

    public function list()
    {
        return view('doctor.patient.patient-list');
    }

    public function view($id = null)
    {
        if (!$id) {
            return redirect()->route('doctor.patient-list')
                ->with('error', 'Please select a patient to view.');
        }

        return view('doctor.patient.patient-view', compact('id'));
    }
}
