<?php

namespace App\Http\Controllers\Doctor;

use App\Models\Doctor;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class DoctorManagementController extends Controller
{
    public function index()
    {
        return view('doctor.doctor.doctor-list');
    }

    public function create()
    {
        return view('doctor.doctor.doctor-form', ['editId' => null]);
    }

    public function edit($id)
    {
        return view('doctor.doctor.doctor-form', ['editId' => $id]);
    }

    public function view($id)
    {
        return view('doctor.doctor.doctor-view', [
            'id' => $id
        ]);
    }

    // Add this new method
    public function clinicManager($doctorId = null)
    {
        return view('doctor.doctor.clinic-manager', [
            'doctorId' => $doctorId
        ]);
    }

    function profile($id)
    {
        return view('doctor.clinic.view', ['id' => $id]);
    }
}