<?php

namespace App\Http\Controllers\Doctor\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use App\Models\ActiveDevice;

class DoctorAuthController extends Controller
{
    public function showLoginForm()
    {
        return view('doctor.auth.login', ['role' => 'doctor']);
    }

    public function logout(Request $request)
    {
        $user = Auth::guard('doctor')->user();

        ActiveDevice::where('user_id', $user->id)
            ->where('device_id', $request->userAgent())
            ->where('role_type', 'doctor')
            ->update([
                'is_active' => false,
                'last_active_at' => now(),
            ]);
        foreach (['web', 'superadmin', 'doctor', 'staff', 'patient'] as $guard) {
            if (Auth::guard($guard)->check()) {
                Auth::guard($guard)->logout();
                Session::flush();
                Session::regenerate();
                break;
            }
        }
        Session::forget('current_role');
        Auth::guard('doctor')->logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return redirect()->route('doctor.login');
    }

    function profile()
    {
        $role = session('current_role');
        return view('doctor.profile' , [
            'role' => $role,
        ]);
    }
}