<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Models\SubscriptionPlan;
use App\Http\Controllers\Controller;

class SubscriptionPlanController extends Controller
{
    public function index()
    {
        return view('admin.plans.subscription-plan.form');
    }
    public function planlist()
    {

        return view('admin.plans.subscription-plan.index');
    }

    public function edit(SubscriptionPlan $plan)
    {
        $plan->load(['limit', 'features.feature', 'usageRates.usageType']);

        return view('admin.plans.subscription-plan.form', [
            'plan' => $plan,
            'planId' => $plan->id
        ]);
    }
    
    public function show(SubscriptionPlan $plan)
    {
        $plan->load(['limit', 'features.feature','usageRates' ,'usageRates.usageType']);

        return view('admin.plans.subscription-plan.view', [
            'plan' => $plan,
            'planId' => $plan->id
        ]);
    }



}
