<?php

namespace App\Http\Controllers\Admin\Clinic;

use App\Models\Clinic;
use App\Http\Controllers\Controller;

class ClinicController extends Controller
{
    public function index()
    {
        return view('admin.clinic.index');   
    }

    public function form(Clinic $clinic = null)
    {
        return view('admin.clinic.form', [
            'clinic' => $clinic
        ]);
    }

    public function view(Clinic $clinic)
    {
        return view('admin.clinic.view', [
            'clinic' => $clinic
        ]);
    }

    public function clinicDoctorEdit(Clinic $clinic , $id)
    {
        return view('admin.clinic.doctor.clinic-doctor-form', [
            'editId' => $id,
            'clinic' => $clinic,
        ]);
    }

    public function clinicDoctorCreate(Clinic $clinic)
    {
        return view('admin.clinic.doctor.clinic-doctor-form', [
            'clinic' => $clinic,
        ]);
    }
}