<?php

namespace App\Http\Controllers\Admin\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use App\Models\ActiveDevice;

class SuperAdminStaffAuthController extends Controller
{
    public function showLoginForm()
    {
        return view('admin.auth.login', ['role' => 'superadminstaff']);
    }

    public function logout(Request $request)
    {
        $user = Auth::user();

        ActiveDevice::where('user_id', $user->id)
            ->where('device_id', $request->userAgent())
            ->where('role_type', 'superadminstaff')
            ->update([
                'is_active' => false,
                'last_active_at' => now(),
            ]);

        Session::forget('current_role');
        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return redirect()->route('admin.staff.login');
    }
}