<?php

// app/Http/Controllers/AppointmentController.php
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use App\Models\Appointment;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Spatie\Permission\Models\Role;
use App\Models\Clinic;
use Carbon\Carbon;

class AppointmentsController extends Controller
{
    public function index()
    {
        return view('admin.appointments.appointment-list');
    }

    public function create()
    {
        // Get all users with 'patient' role
        $patients = User::whereHas('roles', function ($query) {
            $query->where('name', 'patient');
        })->get();

        // Get all users with 'doctor' role
        $doctors = User::whereHas('roles', function ($query) {
            $query->where('name', 'doctor');
        })->get();

        // Get all clinics
        $clinics = Clinic::whereNull('deleted_at')->get();

        return view('admin.appointments.appointment-form', compact('patients', 'doctors', 'clinics'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'patient_id' => 'required|exists:users,id',
            'doctor_id' => 'required|exists:users,id',
            'department' => 'required',
            'appointment_type' => 'required',
            'appointment_date' => 'required|date_format:d-m-Y',
            'appointment_time' => 'required|date_format:h:i A',
            'reason' => 'required',
            'status' => 'required'
        ]);

        Appointment::create([
            'appointment_id' => 'PC' . random_int(100000, 999999),
            'patient_id' => $request->patient_id,
            'doctor_id' => $request->doctor_id,
            'department' => $request->department,
            'appointment_type' => $request->appointment_type,
            'appointment_date' => Carbon::createFromFormat('d-m-Y', $request->appointment_date)->format('Y-m-d'),
            'appointment_time' => Carbon::createFromFormat('h:i A', $request->appointment_time)->format('H:i:s'), // 👈 Convert to 24-hour format
            'reason' => $request->reason,
            'status' => $request->status,
        ]);

        // Appointment::create([
        //     'appointment_id' => 'AP' . random_int(100000, 999999),
        //     'patient_id' => $request->patient_id,
        //     'doctor_id' => $request->doctor_id,
        //     'department' => $request->department,
        //     'appointment_type' => $request->appointment_type,
        //     'appointment_date' => $request->appointment_date,
        //     'appointment_time' => $request->appointment_time,
        //     'reason' => $request->reason,
        //     'status' => $request->status,
        // ]);

        return redirect()->route('admin.appointments.appointment-list')->with('success', 'Appointment created successfully!');
    }



    
}

