<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<?php $sanbi_redux_demo = get_option('redux_demo'); ?>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) { ?>
    <link rel="shortcut icon" href="<?php if(isset($sanbi_redux_demo['favicon']['url'])){?><?php echo esc_url($sanbi_redux_demo['favicon']['url']); ?><?php } ?>">
    <?php } ?>
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>> 
    <!-- ========== Preloader ========== -->
    <div class="preloader">
        <div class="lds-ripple">
            <div></div>
            <div></div>
        </div>
    </div>
    <!-- ========== Preloader ========== -->

    <!-- ========== Site Header ========== -->
    <header class="site-header d-lg-block d-none">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="header-content">
                        <!-- Header Left -->
                        <div class="header-left">
                            <div class="site-logo">
                                <a class="navbar-brand" href="<?php echo esc_url(home_url('/')); ?>">
                                    <?php if(isset($sanbi_redux_demo['logo']['url']) && $sanbi_redux_demo['logo']['url'] != ''){ ?>
                                    <img src="<?php echo esc_url($sanbi_redux_demo['logo']['url']); ?>" alt="logo" />
                                    <?php } else { ?>
                                    <img src="<?php echo get_template_directory_uri();?>/images/logo.png" alt="logo" />
                                    <?php } ?>
                                </a>
                            </div>
                        </div>
                        <!-- Header Left -->
                        <!-- Header Right -->
                        <div class="header-right">
                            <div class="site-navigation">
                                <?php 
                                wp_nav_menu( 
                                    array( 
                                        'theme_location' => 'primary_onepage',
                                        'container' => '',
                                        'menu_class' => '', 
                                        'menu_id' => '',
                                        'menu'            => '',
                                        'container_class' => '',
                                        'container_id'    => '',
                                        'echo'            => true,
                                        'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
                                        'walker'            => new sanbi_wp_bootstrap_navwalker(),
                                        'before'          => '',
                                        'after'           => '',
                                        'link_before'     => '',
                                        'link_after'      => '',
                                        'items_wrap'      => '<ul id=" %1$s" class=" %2$s">%3$s</ul>',
                                        'depth'           => 0,        
                                    )
                                ); ?>
                            </div>
                            <?php if(isset($sanbi_redux_demo['link_button']) && ($sanbi_redux_demo['link_button'] != '')){?>
                            <div class="ms-4">
                                <a href="<?php echo wp_kses_post($sanbi_redux_demo['link_button']); ?>" class="anchor-button secondary button-sm">
                                    <?php echo wp_kses_post($sanbi_redux_demo['button']); ?>
                                </a>
                            </div>
                            <?php } ?>
                        </div>
                        <!-- Header Right -->
                    </div>
                </div>
            </div>
        </div>
    </header>
    <!-- ========== Site Header ========== -->

    <!-- ========== Site Mobile Header ========== -->
    <header class="site-mobile-header d-block d-lg-none">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="header-content">
                        <!-- Header Left -->
                        <div class="header-left">
                            <div class="site-logo">
                                <a class="navbar-brand" href="<?php echo esc_url(home_url('/')); ?>">
                                    <?php if(isset($sanbi_redux_demo['logo']['url']) && $sanbi_redux_demo['logo']['url'] != ''){ ?>
                                    <img src="<?php echo esc_url($sanbi_redux_demo['logo']['url']); ?>" alt="logo" />
                                    <?php } else { ?>
                                    <img src="<?php echo get_template_directory_uri();?>/images/logo.png" alt="logo" />
                                    <?php } ?>
                                </a>
                            </div>
                        </div>              
                        <!-- Header Left -->
                        <!-- Header Right -->
                        <div class="header-right">
                            <?php if(isset($sanbi_redux_demo['link_button']) && ($sanbi_redux_demo['link_button'] != '')){?>
                            <div class="ms-4">
                                <a href="<?php echo wp_kses_post($sanbi_redux_demo['link_button']); ?>" class="anchor-button secondary button-sm">
                                    <?php echo wp_kses_post($sanbi_redux_demo['button']); ?>
                                </a>
                            </div>
                            <?php } ?>
                            <div class="mobile-nav-toggle">
                                <i class="las la-bars"></i>
                            </div>
                        </div>
                        <!-- Header Right -->
                    </div>
                </div>
            </div>
        </div>
    </header>
    <!-- ========== Site Mobile Header ========== -->

    <!-- ========== Mobile Navigation ========== -->
    <div class="mobile-navigation-wrap p-4">
        <!-- Menu Close -->
        <div class="nav-header">
            <i class="las la-times-circle hide-mobile-nav"></i>
        </div>
        <!-- Menu Close -->

        <!-- Navigation Items -->
        <div class="mobile-nav">
            <?php 
            wp_nav_menu( 
                array( 
                    'theme_location' => 'primary_onepage',
                    'container' => '',
                    'menu_class' => '', 
                    'menu_id' => '',
                    'menu'            => '',
                    'container_class' => '',
                    'container_id'    => '',
                    'echo'            => true,
                    'fallback_cb'       => 'wp_bootstrap_navwalker::fallback',
                    'walker'            => new sanbi_wp_bootstrap_navwalker(),
                    'before'          => '',
                    'after'           => '',
                    'link_before'     => '',
                    'link_after'      => '',
                    'items_wrap'      => '<ul id=" %1$s" class=" %2$s">%3$s</ul>',
                    'depth'           => 0,        
                )
            ); ?>
        </div>
        <!-- Navigation Items -->  
    </div>
    <!-- ========== Mobile Navigation ========== -->