<?php
$sanbi_redux_demo = get_option('redux_demo');
get_header(); ?>
<div class="sanbi_tm_section page-banner">
    <div class="sanbi_tm_news">
        <?php if(isset($sanbi_redux_demo['background_blog']['url']) && $sanbi_redux_demo['background_blog']['url'] != ''){ ?>  
        <div class="news_inner single-blog" style="background-image:url(<?php echo esc_url($sanbi_redux_demo['background_blog']['url']); ?>);">
        <?php } else { ?>
        <div class="news_inner single-blog" style="background-image:url(<?php echo get_template_directory_uri();?>/images/blog/page-banner.jpg);">
        <?php } ?>
            <div class="container text-center">
                <div class="sanbi_tm_main_title blog-title">
                    <div class="title">
                        <h1><?php printf( esc_html__( 'Category: %s', 'sanbi' ), single_cat_title( '', false ) ); ?></h1>
                    </div>
                </div>
                <div class="content">
                    <div class="breadcrumbs">
                        <p><span><a href="<?php echo esc_url(home_url('/')); ?>"><?php if(isset($sanbi_redux_demo['blog_home_text'])){?>
                        <?php echo htmlspecialchars_decode(esc_attr($sanbi_redux_demo['blog_home_text']));?>
                        <?php }else{?>
                        <?php echo esc_html__( 'Home', 'sanbi' );
                        }
                        ?></a></span> / <span class="active"><?php echo esc_html__( 'Category', 'sanbi' ); ?></span></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<section class="sanbi_tm_section bx-section padding-b-80">
    <div class="sanbi_tm_news">
        <div class="news_inner blog-news blog-list">
            <div class="container">
                <div class="row">
                    <div class="col-md-12 col-lg-8">
                        <div class="leftbox">
                            <?php while (have_posts()): the_post(); ?>
                            <div class="news_list">
                                <div class="list_inner blog_single_details">
                                    <?php if ( has_post_thumbnail() ) { ?>
                                    <div class="image thumb">
                                        <a href="<?php the_permalink(); ?>"><img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" alt="" /></a>
                                    </div>
                                    <?php } ?>
                                    <div class="post-info">
                                        <span class="date"><?php the_time(get_option( 'date_format' ));?></span>
                                        <span class="comment"><?php comments_number( esc_html__('0 Comments', 'sanbi'), esc_html__('1 Comment', 'sanbi'), esc_html__('% Comments', 'sanbi') ); ?></span>
                                    </div>
                                    <h4 class="post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                    <p><?php if(isset($sanbi_redux_demo['blog_excerpt'])){?>
                                        <?php echo esc_attr(sanbi_excerpt($sanbi_redux_demo['blog_excerpt'])); ?>
                                        <?php }else{?>
                                        <?php echo esc_attr(sanbi_excerpt(40)); 
                                        }
                                        ?></p>
                                    <div class="sx-post-readmore">
                                        <a href="<?php the_permalink(); ?>" title="READ MORE" rel="bookmark" class="site-button icon"><i class="fa  fa-long-arrow-right"></i>
                                            <?php if(isset($sanbi_redux_demo['read_more'])){?>
                                            <?php echo wp_specialchars_decode(esc_attr($sanbi_redux_demo['read_more']));?>
                                            <?php }else{?>
                                            <?php echo esc_html__( 'Read More ', 'sanbi' );
                                            }
                                            ?></a>
                                    </div>
                                </div>
                            </div>
                            <?php endwhile; ?>
                            <div class="aon-paging-control">
                                <?php sanbi_pagination(); ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12 col-lg-4">
                        <div class="rightbox rightSidebar">
                            <?php get_sidebar();?>
                        </div> 
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php
get_footer();
?>