<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsQuote extends \Elementor\Widget_Base {

    /**
     * Get widget name.
     *
     * Retrieve Bdevs Elementor widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'bdevs-quote';
    }

    /**
     * Get widget title.
     *
     * Retrieve Bdevs Elementor widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'Quote', 'bdevs-elementor' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve Bdevs About widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-editor-quote';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Bdevs About widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'bdevs-elementor' ];
    }

    public function get_keywords() {
        return [ 'quote' ];
    }

    public function get_script_depends() {
        return [ 'bdevs-elementor'];
    }

    // BDT Position
    protected function element_pack_position() {
        $position_options = [
            ''              => esc_html__('Default', 'bdevs-elementor'),
            'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
            'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
            'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
            'center'        => esc_html__('Center', 'bdevs-elementor') ,
            'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
            'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
            'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
            'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
            'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
        ];

        return $position_options;
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'section_content_about',
            [
                'label' => esc_html__( 'Quote', 'bdevs-elementor' ),
            ]   
        );
        $this->add_control(
            'left_image',
            [
                'label'   => esc_html__( 'Left Image', 'bdevs-elementor' ),
                'type'    => Controls_Manager::MEDIA,
                'dynamic' => [ 'active' => true ],
                'description' => esc_html__( 'Add image from here', 'bdevs-elementor' ),
            ]
        );
        $this->add_control(
            'quote',
            [
                'label'       => __( 'Quote:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter your quote', 'bdevs-elementor' ),
                'default'     => __( 'We accept that flawlessness is exaggerated and frequently disillusions when the commerce objectives are what checks.', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        ); 
        $this->add_control(
            'name',
            [
                'label'       => __( 'Name:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your name', 'bdevs-elementor' ),
                'default'     => __( 'Bellal Dhar', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'job',
            [
                'label'       => __( 'Job:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your job', 'bdevs-elementor' ),
                'default'     => __( 'Ceo & Founder', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );     
        $this->end_controls_section();
        /** 
        *   Layout section 
        **/
        $this->start_controls_section(
            'section_content_layout',
            [
                'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
            ]
        );
        $this->add_responsive_control(
            'align',
            [
                'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-justify',
                    ],
                ],
                'prefix_class' => 'elementor%s-align-',
                'description'  => 'Use align to match position',
                'default'      => 'left',
            ]
        );
        $this->end_controls_section();

    }

    public function render() {
    $settings  = $this->get_settings_for_display();
    extract($settings); ?>
    <section>
        <div class="container">
            <div class="row mt-5">
                <div class="col-md-12">
                    <!-- CEO Message -->
                    <div class="ceo-message-wrap p-5">
                        <div class="row align-items-center"> 
                            <?php if(isset($settings['left_image']['url']) && $settings['left_image']['url'] != ''){?>
                            <div class="col-lg-5 mb-lg-0 mb-4">
                                <div class="ceo-image">
                                    <img src="<?php echo wp_kses_post($settings['left_image']['url']); ?>" alt="Ceo Image">
                                </div>
                            </div> 
                            <?php } ?>
                            <div class="col-lg-7">
                                <div class="ceo-message-content ms-lg-4">
                                    <?php if(isset($settings['quote']) && $settings['quote'] != ''){?>
                                    <div class="ceo-message-text mb-4">
                                        <?php print wp_kses_post($settings['quote']); ?>
                                    </div>
                                    <?php } ?>
                                    <div class="meta">
                                        <?php if(isset($settings['name']) && $settings['name'] != ''){?>
                                        <div><strong><?php print wp_kses_post($settings['name']); ?></strong></div>
                                        <?php } ?>
                                        <?php if(isset($settings['job']) && $settings['job'] != ''){?>
                                        <div><?php print wp_kses_post($settings['job']); ?></div>
                                        <?php } ?> 
                                    </div>
                                </div> 
                            </div>
                        </div>
                    <!-- CEO Message -->
                    </div>
                </div> 
            </div>
        </div>  
    </section>
    <?php
    }
}


