<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsExtendedFeatures extends \Elementor\Widget_Base {

    /**
     * Get widget name.
     *
     * Retrieve Bdevs Elementor widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'bdevs-extended-features';
    }

    /**
     * Get widget title.
     *
     * Retrieve Bdevs Elementor widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'Extended Features', 'bdevs-elementor' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve Bdevs About widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-posts-justified';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Bdevs About widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'bdevs-elementor' ];
    }

    public function get_keywords() {
        return [ 'extended features' ];
    }

    public function get_script_depends() {
        return [ 'bdevs-elementor'];
    }

    // BDT Position
    protected function element_pack_position() {
        $position_options = [
            ''              => esc_html__('Default', 'bdevs-elementor'),
            'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
            'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
            'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
            'center'        => esc_html__('Center', 'bdevs-elementor') ,
            'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
            'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
            'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
            'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
            'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
        ];

        return $position_options;
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'section_content_heading',
            [
                'label' => esc_html__( 'Extended Features', 'bdevs-elementor' ),
            ]   
        );
        $this->add_control(
            'subheading',
            [
                'label'       => __( 'Subheading:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your subheading', 'bdevs-elementor' ),
                'default'     => __( 'EXTENDED FEATURES', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'heading',
            [
                'label'       => __( 'Heading:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
                'default'     => __( 'Simple, Yet Powerful Features', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'description',
            [
                'label'       => __( 'Description:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter your description', 'bdevs-elementor' ),
                'default'     => __( 'There is More Than One Way To Eat A Extended features.', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'left_title',
            [
                'label'       => __( 'Left Title:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter your left title', 'bdevs-elementor' ),
                'default'     => __( 'Highly Secure', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'left_description',
            [
                'label'       => __( 'Left Description:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter your left description', 'bdevs-elementor' ),
                'default'     => __( 'One Highly secure is better than two of something else.', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'tabs',
            [
                'label' => esc_html__( 'Items', 'bdevs-elementor' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name'        => 'icon',
                        'label'       => esc_html__( 'Icon:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'las la-paw' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'title',
                        'label'       => esc_html__( 'Title:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'Business Data' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'text',
                        'label'       => esc_html__( 'Text:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXTAREA,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'Feel The Raw Naked business data Of The Road.' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                ],
            ]
        );
        $this->add_control(
            'right_image',
            [
                'label'   => esc_html__( 'Right Image:', 'bdevs-elementor' ),
                'type'    => Controls_Manager::MEDIA,
                'dynamic' => [ 'active' => true ],
                'description' => esc_html__( 'Add image from here', 'bdevs-elementor' ),
            ]
        );
        $this->end_controls_section();
        /** 
        *   Layout section 
        **/
        $this->start_controls_section(
            'section_content_layout',
            [
                'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
            ]
        );
        $this->add_responsive_control(
            'align',
            [
                'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-justify',
                    ],
                ],
                'prefix_class' => 'elementor%s-align-',
                'description'  => 'Use align to match position',
                'default'      => 'left',
            ]
        );
        $this->add_control(
            'show_subheading',
            [
                'label'   => esc_html__( 'Show Subheading', 'bdevs-elementor' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_heading',
            [
                'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->end_controls_section();

    }

    public function render() {
    $settings  = $this->get_settings_for_display();
    extract($settings); ?>
    <section class="sp-t">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 mx-auto text-center mb-5">
                    <!-- Section Heading -->
                    <div class="section-heading">
                        <?php if ( $settings['show_subheading'] ) : ?>
                        <div class="sub-heading">
                            <p><?php print wp_kses_post($settings['subheading']); ?></p>
                        </div>
                        <?php endif; ?>
                        <?php if ( $settings['show_heading'] ) : ?>
                        <div class="heading-title">
                            <h2><?php print wp_kses_post($settings['heading']); ?></h2>
                        </div>
                        <?php endif; ?>
                        <?php if(isset($settings['description']) && $settings['description'] != ''){?>
                        <div class="heading-description">
                            <p><?php print wp_kses_post($settings['description']); ?></p>
                        </div>
                        <?php } ?>
                    </div>
                    <!-- Section Heading -->
                </div>
            </div>
          <div class="row align-items-center">
            <div class="col-lg-5">
              <!-- Feature Content -->
              <div class="extended-feature-content mb-lg-0 mb-5">
                <div class="mb-4">
                    <?php if(isset($settings['left_title']) && $settings['left_title'] != ''){?>
                    <h3><?php print wp_kses_post($settings['left_title']); ?></h3>
                    <?php } ?>
                    <?php if(isset($settings['left_description']) && $settings['left_description'] != ''){?>
                    <p><?php print wp_kses_post($settings['left_description']); ?></p>
                    <?php } ?>
                </div>
                <?php foreach ( $settings['tabs'] as $item ) :   ?>
                <div class="iconbox-secondary mb-4">
                    <?php if(isset($item['icon']) && $item['icon'] != ''){?>
                    <div class="item-icon darkyellow me-4">
                      <i class="<?php print wp_kses_post($item['icon']); ?>"></i>
                    </div>
                    <?php } ?>
                    <div class="item-content">
                        <?php if(isset($item['title']) && $item['title'] != ''){?>
                        <h4><?php print wp_kses_post($item['title']); ?></h4>
                        <?php } ?>
                        <?php if(isset($item['text']) && $item['text'] != ''){?>
                        <p><?php print wp_kses_post($item['text']); ?></p>
                        <?php } ?>
                    </div>
                </div>
                <?php endforeach; ?>
              </div>
              <!-- Feature Content -->
            </div>
            <?php if(isset($settings['right_image']['url']) && $settings['right_image']['url'] != ''){?>
            <div class="col-lg-7">
              <div class="extended-feature-image">
                <img src="<?php echo wp_kses_post($settings['right_image']['url']); ?>" alt="Feature Image 02">
              </div>
            </div>
            <?php } ?>
          </div>
        </div>
      </section>
    <?php
    }
}


