<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsBanner extends \Elementor\Widget_Base {

    /**
     * Get widget name.
     *
     * Retrieve Bdevs Elementor widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'bdevs-banner';
    }

    /**
     * Get widget title.
     *
     * Retrieve Bdevs Elementor widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'Banner', 'bdevs-elementor' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve Bdevs About widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-banner';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Bdevs About widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'bdevs-elementor' ];
    }

    public function get_keywords() {
        return [ 'banner' ];
    }

    public function get_script_depends() {
        return [ 'bdevs-elementor'];
    }

    // BDT Position
    protected function element_pack_position() {
        $position_options = [
            ''              => esc_html__('Default', 'bdevs-elementor'),
            'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
            'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
            'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
            'center'        => esc_html__('Center', 'bdevs-elementor') ,
            'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
            'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
            'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
            'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
            'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
        ];

        return $position_options;
    }

    protected function _register_controls() {
        
        $this->start_controls_section(
            'section_content_banner',
            [
                'label' => esc_html__( 'Banner', 'bdevs-elementor' ),
            ]   
        );
        $this->add_control(
            'background_image',
            [
                'label'   => esc_html__( 'Background Image', 'bdevs-elementor' ),
                'type'    => Controls_Manager::MEDIA,
                'dynamic' => [ 'active' => true ],
                'description' => esc_html__( 'Add image from here', 'bdevs-elementor' ),
            ]
        ); 
        $this->add_control(
            'heading',
            [
                'label'       => __( 'Heading:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your heading', 'bdevs-elementor' ),
                'default'     => __( 'Simple yet <br>Elegant Design. <br>Better Looks.', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'description',
            [
                'label'       => __( 'Description:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'Enter your description', 'bdevs-elementor' ),
                'default'     => __( 'Trending, Clean and Elegant Design based on<br>deeply
                      research with powerful features.', 'bdevs-elementor' ),
                'label_block' => true,
            ]
        ); 
        $this->add_control(
            'link_button_1',
            [
                'label'       => __( 'Link Button 1:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter link button', 'bdevs-elementor' ),
                'default'     => __( '#' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button_1_image',
            [
                'label'   => esc_html__( 'Button 1 Image', 'bdevs-elementor' ),
                'type'    => Controls_Manager::MEDIA,
                'dynamic' => [ 'active' => true ],
                'description' => esc_html__( 'Add image from here', 'bdevs-elementor' ),
            ]
        );
        $this->add_control(
            'link_button_2',
            [
                'label'       => __( 'Link Button 2:', 'bdevs-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter link button', 'bdevs-elementor' ),
                'default'     => __( '#' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'button_2_image',
            [
                'label'   => esc_html__( 'Button 2 Image', 'bdevs-elementor' ),
                'type'    => Controls_Manager::MEDIA,
                'dynamic' => [ 'active' => true ],
                'description' => esc_html__( 'Add image from here', 'bdevs-elementor' ),
            ]
        );
        $this->add_control(
            'right_image',
            [
                'label'   => esc_html__( 'Right Image', 'bdevs-elementor' ),
                'type'    => Controls_Manager::MEDIA,
                'dynamic' => [ 'active' => true ],
                'description' => esc_html__( 'Add image from here', 'bdevs-elementor' ),
            ]
        ); 
        $this->end_controls_section();

        /** 
        *   Layout section 
        **/
        $this->start_controls_section(
            'section_content_layout',
            [
                'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-justify',
                    ],
                ],
                'prefix_class' => 'elementor%s-align-',
                'description'  => 'Use align to match position',
                'default'      => 'left',
            ]
        );
        $this->add_control(
            'show_heading',
            [
                'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->end_controls_section();

    }
    public function render() {
    $settings  = $this->get_settings_for_display();
    extract($settings); 
    ?> 
    <section class="site-banner" id="home" style="background-image: url(<?php echo wp_kses_post($settings['background_image']['url']);?>)">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <!-- Banner Heading --> 
                    <div class="banner-heading">
                        <div class="banner-text mb-4">
                            <?php if ( $settings['show_heading'] ) : ?>
                            <div class="banner-title">
                                <h1><?php print wp_kses_post($settings['heading']); ?></h1>
                            </div>
                            <?php endif; ?>
                            <?php if(isset($settings['description']) && $settings['description'] != ''){?>
                            <div class="banner-description">
                                <p><?php print wp_kses_post($settings['description']); ?></p>
                            </div>
                            <?php } ?>
                        </div>    
                        <div class="banner-download-buttons">
                            <?php if(isset($settings['link_button_1']) && $settings['link_button_1'] != ''){?>
                            <a href="<?php print wp_kses_post($settings['link_button_1']); ?>">
                                <?php if(isset($settings['button_1_image']['url']) && $settings['button_1_image']['url'] != ''){?>
                                <img src="<?php echo wp_kses_post($settings['button_1_image']['url']); ?>" alt="App Store">
                                <?php } ?>
                            </a>
                            <?php } ?>
                            <?php if(isset($settings['link_button_2']) && $settings['link_button_2'] != ''){?>
                            <a href="<?php print wp_kses_post($settings['link_button_2']); ?>">
                                <?php if(isset($settings['button_2_image']['url']) && $settings['button_2_image']['url'] != ''){?>
                                <img src="<?php echo wp_kses_post($settings['button_2_image']['url']); ?>" alt="Play Store">
                                <?php } ?>
                            </a>
                            <?php } ?>
                        </div>
                    </div>
                    <!-- Banner Heading -->
                </div>
                <?php if(isset($settings['right_image']['url']) && $settings['right_image']['url'] != ''){?>
                <div class="col-lg-6 mt-lg-0 mt-5 d-lg-block d-none">
                    <!-- Banner Image -->
                    <div class="banner-image">
                        <img src="<?php echo wp_kses_post($settings['right_image']['url']); ?>" alt="Mobile Banner Image">
                    </div>
                    <!-- Banner Image -->
                </div>
                <?php } ?>
            </div>
        </div>
    </section>         
    <?php
    }

}

